/*
 * ----------------------------
 * Created By: FelipeGamer-Dev
 * For: True Cowboy
 * ----------------------------
*/

import { world } from "mojang-minecraft";
import { utilities } from "./utilities";

const protectedPlayers = new Set();
const setHealth = new Map();

world.events.tick.subscribe((ev) => {
  for (const player of world.getPlayers()) {
    const inventoryContainer = player.getComponent("minecraft:inventory").container;
    const hand = inventoryContainer.getItem(player.selectedSlot);
    const nameTag = player.nameTag;
    
    if (!hand) continue;
    const itemId = utilities.removeNamespace(hand.id);

    if (itemId.includes("twohanded") && player.isSneaking) {
      if (!protectedPlayers.has(nameTag)) {
        protectedPlayers.add(nameTag);
      }
      player.runCommand("effect @s weakness 1 5 true");
      player.runCommand("playanimation @s animation.player.weapon_blocking");
    } else if (protectedPlayers.has(nameTag)) {
      protectedPlayers.delete(nameTag);
    }
    
    if (setHealth.get(nameTag) !== undefined && (ev.currentTick % 2.5) == 0) {
      player.getComponent("minecraft:health").setCurrent(setHealth.get(nameTag));
      setHealth.delete(nameTag);
    }
  }
});

world.events.entityHurt.subscribe((evt) => {
  const { damagingEntity, hurtEntity, damage, projectile } = evt;

  if (!utilities.isPlayer(hurtEntity)) return;
  else if (!protectedPlayers.has(hurtEntity.nameTag)) return;
  else if (projectile) {
    if (utilities.isThrowPotion(projectile)) return;
    const playerHealth = hurtEntity.getComponent("minecraft:health");
    
    utilities.playSound("item.shield.block", hurtEntity);
    utilities.damageMainhand(hurtEntity, 2);
    setHealth.set(hurtEntity.nameTag, playerHealth.current + damage);
  } else if (damagingEntity) {
    const damageReduction = damage / 0.6;
    const resultDamage = Math.max(damage, damageReduction) - Math.min(damage, damageReduction);
    const playerHealth = hurtEntity.getComponent("minecraft:health");
    
    utilities.playSound("item.shield.block", hurtEntity);
    utilities.damageMainhand(hurtEntity, 2);
    setHealth.set(hurtEntity.nameTag, playerHealth.current + resultDamage);
  }
});

